import java.io.*;

public class CFavorite 
{
	static int DIRECTORY_SIZE = 200;

	private RandomAccessFile f;
	private String strBookmarkDir = "bookmark.html";
	private String strFavoriteDir = "c:\\windows\\favorites";
	private boolean flag_error = false;

	public CFavorite()
	{

		try
		{
			f = new RandomAccessFile(strBookmarkDir, "rw");
		}
		catch (IOException e)
		{
			System.out.println("failure to open file: " + strBookmarkDir + "\n");
			flag_error = true;
		}

	}
	public CFavorite(String cpBookmarkDir)
	{
		strBookmarkDir = cpBookmarkDir;

		try
		{
			f = new RandomAccessFile(strBookmarkDir, "rw");
		}
		catch (IOException e)
		{
			System.out.println("failure to open file: " + strBookmarkDir + "\n");
			flag_error = true;
		}
	}
	public CFavorite(char cpBookmarkDir[], char cpFavoriteDir[])
	{
		strBookmarkDir = new String(cpBookmarkDir);
		strFavoriteDir = new String(cpFavoriteDir);

		try
		{
			f = new RandomAccessFile(strBookmarkDir, "rw");
		}
		catch (IOException e)
		{
			System.out.println("failure to open file: " + strBookmarkDir + "\n");
			flag_error = true;
		}
	}

	public CFavorite(String cpBookmarkDir, String cpFavoriteDir)
	{
		strBookmarkDir = cpBookmarkDir;
		strFavoriteDir = cpFavoriteDir;

		try
		{
			f = new RandomAccessFile(strBookmarkDir, "rw");
		}
		catch (IOException e)
		{
			System.out.println("failure to open file: " + strBookmarkDir + "\n");
			flag_error = true;
		}
	}

	protected void finalize() throws Throwable
	{
		f.close();
		super.finalize();
	}


	public String GetFavoriteDir()
	{
		return strFavoriteDir;
	}

	public boolean IsError()
	{
		return flag_error;
	}

	private boolean MyWrite(String str)
	{
		try
		{
			f.write(str.getBytes());
		}
		catch (IOException e)
		{
			System.out.println("failure write to object file!\n");
			return false;
		}
		return true;
	}

	public void AddDirContent(String strDir, String strFile)
	{
		File finder;

		if (strFile.length() == 0)
			strFile = strDir;
		else
			strFile = strDir + "\\" + strFile;

		try
		{
			finder = new File(strFile);    
		}
		catch (NullPointerException e)
		{
			System.out.println("failure to change directory: " + strFile + "\n");
			return;
		}

		String strFiles[] = finder.list();

		for (int i=0; i<strFiles.length; i++)
		{        
			String fname = strFiles[i];
			File f1;

			try
			{
				f1 = new File(strFile, fname);
			}
			catch (NullPointerException e)
			{
				System.out.println("failure to change directory: " + strFile + "\\" + fname + "\n");
				return;
			}

			if (f1.isDirectory())
			{
				if (!IsDirEmpty(strFile, fname))
					AddDir(strFile, fname);
			}
			else
			{
				if ((fname.toUpperCase()).endsWith(".URL"))
                                        AddURL(strFile, fname);
			}
		}

	}

	public void AddDirContent(String strDir)
	{
                AddDirContent(strDir, "");
        }

	public void AddFileHead()
	{
		MyWrite("<!DOCTYPE NETSCAPE-Bookmark-file-1>\n" +
                        "<!-- This is a file generated by Xia Feng's URL2HTML.\n" +
			"It will be read and overwritten.\n" +
			"Do Not Edit! -->\n" +
                        "<meta name=\"GENERATOR\" content=\"URL2HTML by Xia Feng\">" +
			"<TITLE>li jie's Bookmarks</TITLE>\n" +
			"<H1>li jie's Bookmarks</H1>\n\n");
	}

	public void AddDirHead()
	{
		MyWrite("<DL><p>\n");
	}


	public void AddDirTail()
	{
		MyWrite("</DL><p>\n");
	}

	public void AddDir(String dirName, String fname)
	{

		MyWrite("<DT><H3 ADD_DATE=\"884567655\">" + fname + "</H3>\n");

		AddDirHead();
		AddDirContent(dirName, fname);
		AddDirTail();
	}

        public void AddURL(String dirName, String name)
	{
                FileInputStream furl;
                String url = " ";
                byte ch[] = new byte[10];

                dirName = dirName + "\\" + name;

		try
		{
                        furl = new FileInputStream(dirName);
                        while ( furl.read(ch) != -1) 
			{
                                String s = new String(ch);
                                url= url + s;
			}
                        furl.close();

                        int index1 = url.indexOf("URL=");
                        if (index1 == -1)
                                return;
                        index1 += 4;

                        int index2 = url.indexOf("\n", index1);
                        if (index2 == -1)
                                return;

                        url = url.substring(index1, index2);
                }
                catch (FileNotFoundException e)
                {
                        System.out.println("failure to open file: " + dirName + "\n");
                        return;
                }
		catch (IOException e)
		{
                        System.out.println("failure to read file: " + dirName + "\n");
                        return;
		}
		catch (SecurityException e)
		{
                        System.out.println("you have no right to read file: " + dirName + "\n");
                        return;
		}
		catch (StringIndexOutOfBoundsException  e)
		{
			System.out.println("failure to get substring of : " + url + "\n");
			return;
		}

		name = name.substring(0, name.length() - 3);

                MyWrite("<DT><A HREF=\"" + url + "\"" 
			+ "ADD_DATE=\"882645605\" LAST_VISIT=\"886620180\" LAST_MODIFIED=\"882645585\">" 
			+ name + " </A>\n");
	}



	private boolean IsDirEmpty(String strDir, String strFile)
	{
		File finder;

		if (strFile.length() == 0)
			strFile = strDir;
		else
			strFile = strDir + "\\" + strFile;

		try
		{
			finder = new File(strFile);    
		}
		catch (NullPointerException e)
		{
			System.out.println("failure to change directory: " + strFile + "\n");
			return true;
		}

		String strFiles[] = finder.list();
		boolean empty = true;

		for (int i=0; i<strFiles.length; i++)
		{        
			String fname = strFiles[i];
			File f1;

			try
			{
				f1 = new File(strFile, fname);
			}
			catch (NullPointerException e)
			{
				System.out.println("failure to change directory: " + strFile + "\\" + fname + "\n");
				continue;
			}

			if (f1.isDirectory())
			{
				if (!IsDirEmpty(strFile, fname))
				{
					empty = false;
					break;
				}
			}
			else
			{
				if ((fname.toUpperCase()).endsWith(".URL"))
				{
					empty = false;
					break;
				}
			}
		}
		return empty;

	}

}

